"use strict";
'use client';

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMPTY_DETAIL_PANELS = void 0;
exports.areRenderContextsEqual = areRenderContextsEqual;
exports.computeOffsetLeft = computeOffsetLeft;
exports.useGridVirtualScroller = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var ReactDOM = _interopRequireWildcard(require("react-dom"));
var _useEventCallback = _interopRequireDefault(require("@mui/utils/useEventCallback"));
var _useEnhancedEffect = _interopRequireDefault(require("@mui/utils/useEnhancedEffect"));
var _useLazyRef = _interopRequireDefault(require("@mui/utils/useLazyRef"));
var _useTimeout = _interopRequireDefault(require("@mui/utils/useTimeout"));
var _RtlProvider = require("@mui/system/RtlProvider");
var _reactMajor = _interopRequireDefault(require("@mui/x-internals/reactMajor"));
var _gridDimensionsSelectors = require("../dimensions/gridDimensionsSelectors");
var _useGridPrivateApiContext = require("../../utils/useGridPrivateApiContext");
var _useGridRootProps = require("../../utils/useGridRootProps");
var _useGridSelector = require("../../utils/useGridSelector");
var _useRunOnce = require("../../utils/useRunOnce");
var _gridColumnsSelector = require("../columns/gridColumnsSelector");
var _gridRowsSelector = require("../rows/gridRowsSelector");
var _useGridVisibleRows = require("../../utils/useGridVisibleRows");
var _utils = require("../../utils");
var platform = _interopRequireWildcard(require("../../../utils/platform"));
var _utils2 = require("../../../utils/utils");
var _gridRowsMetaSelector = require("../rows/gridRowsMetaSelector");
var _gridColumnsUtils = require("../columns/gridColumnsUtils");
var _gridVirtualizationSelectors = require("./gridVirtualizationSelectors");
var _useGridVirtualization = require("./useGridVirtualization");
var _gridRowSpanningSelectors = require("../rows/gridRowSpanningSelectors");
var _gridListViewSelectors = require("../listView/gridListViewSelectors");
var _gridRowsUtils = require("../rows/gridRowsUtils");
var _columns = require("../columns");
var _gridFocusedVirtualCellSelector = require("./gridFocusedVirtualCellSelector");
var _roundToDecimalPlaces = require("../../../utils/roundToDecimalPlaces");
var _isJSDOM = require("../../../utils/isJSDOM");
var _rowSelection = require("../rowSelection");
var _jsxRuntime = require("react/jsx-runtime");
const MINIMUM_COLUMN_WIDTH = 50;
var ScrollDirection = /*#__PURE__*/function (ScrollDirection) {
  ScrollDirection[ScrollDirection["NONE"] = 0] = "NONE";
  ScrollDirection[ScrollDirection["UP"] = 1] = "UP";
  ScrollDirection[ScrollDirection["DOWN"] = 2] = "DOWN";
  ScrollDirection[ScrollDirection["LEFT"] = 3] = "LEFT";
  ScrollDirection[ScrollDirection["RIGHT"] = 4] = "RIGHT";
  return ScrollDirection;
}(ScrollDirection || {});
const EMPTY_SCROLL_POSITION = {
  top: 0,
  left: 0
};
const EMPTY_DETAIL_PANELS = exports.EMPTY_DETAIL_PANELS = Object.freeze(new Map());
const createScrollCache = (isRtl, rowBufferPx, columnBufferPx, verticalBuffer, horizontalBuffer) => ({
  direction: ScrollDirection.NONE,
  buffer: bufferForDirection(isRtl, ScrollDirection.NONE, rowBufferPx, columnBufferPx, verticalBuffer, horizontalBuffer)
});
const useGridVirtualScroller = () => {
  const apiRef = (0, _useGridPrivateApiContext.useGridPrivateApiContext)();
  const rootProps = (0, _useGridRootProps.useGridRootProps)();
  const {
    listView
  } = rootProps;
  const visibleColumns = (0, _useGridSelector.useGridSelector)(apiRef, () => listView ? [(0, _gridListViewSelectors.gridListColumnSelector)(apiRef)] : (0, _gridColumnsSelector.gridVisibleColumnDefinitionsSelector)(apiRef));
  const enabledForRows = (0, _useGridSelector.useGridSelector)(apiRef, _gridVirtualizationSelectors.gridVirtualizationRowEnabledSelector) && !_isJSDOM.isJSDOM;
  const enabledForColumns = (0, _useGridSelector.useGridSelector)(apiRef, _gridVirtualizationSelectors.gridVirtualizationColumnEnabledSelector) && !_isJSDOM.isJSDOM;
  const pinnedRows = (0, _useGridSelector.useGridSelector)(apiRef, _gridRowsSelector.gridPinnedRowsSelector);
  const pinnedColumnDefinitions = (0, _gridColumnsSelector.gridVisiblePinnedColumnDefinitionsSelector)(apiRef);
  const pinnedColumns = listView ? _columns.EMPTY_PINNED_COLUMN_FIELDS : pinnedColumnDefinitions;
  const hasBottomPinnedRows = pinnedRows.bottom.length > 0;
  const [panels, setPanels] = React.useState(EMPTY_DETAIL_PANELS);
  const isRtl = (0, _RtlProvider.useRtl)();
  const rowSelectionManager = (0, _useGridSelector.useGridSelector)(apiRef, _rowSelection.gridRowSelectionManagerSelector);
  const currentPage = (0, _useGridVisibleRows.useGridVisibleRows)(apiRef);
  const mainRef = apiRef.current.mainElementRef;
  const scrollerRef = apiRef.current.virtualScrollerRef;
  const scrollbarVerticalRef = apiRef.current.virtualScrollbarVerticalRef;
  const scrollbarHorizontalRef = apiRef.current.virtualScrollbarHorizontalRef;
  const hasColSpan = (0, _useGridSelector.useGridSelector)(apiRef, _gridColumnsSelector.gridHasColSpanSelector);
  const isRenderContextReady = React.useRef(false);
  const rowHeight = (0, _useGridSelector.useGridSelector)(apiRef, _gridDimensionsSelectors.gridRowHeightSelector);
  const contentHeight = (0, _useGridSelector.useGridSelector)(apiRef, _gridDimensionsSelectors.gridContentHeightSelector);
  const columnsTotalWidth = (0, _useGridSelector.useGridSelector)(apiRef, _gridDimensionsSelectors.gridColumnsTotalWidthSelector);
  const needsHorizontalScrollbar = (0, _useGridSelector.useGridSelector)(apiRef, needsHorizontalScrollbarSelector);
  const verticalScrollbarWidth = (0, _useGridSelector.useGridSelector)(apiRef, _gridDimensionsSelectors.gridVerticalScrollbarWidthSelector);
  const gridHasFiller = (0, _useGridSelector.useGridSelector)(apiRef, _gridDimensionsSelectors.gridHasFillerSelector);
  const previousSize = React.useRef(null);
  const mainRefCallback = React.useCallback(node => {
    mainRef.current = node;
    if (!node) {
      return undefined;
    }
    const initialRect = node.getBoundingClientRect();
    let lastSize = {
      width: (0, _roundToDecimalPlaces.roundToDecimalPlaces)(initialRect.width, 1),
      height: (0, _roundToDecimalPlaces.roundToDecimalPlaces)(initialRect.height, 1)
    };
    if (!previousSize.current || lastSize.width !== previousSize.current.width && lastSize.height !== previousSize.current.height) {
      previousSize.current = lastSize;
      apiRef.current.publishEvent('resize', lastSize);
    }
    if (typeof ResizeObserver === 'undefined') {
      return undefined;
    }
    const observer = new ResizeObserver(entries => {
      const entry = entries[0];
      if (!entry) {
        return;
      }
      const newSize = {
        width: (0, _roundToDecimalPlaces.roundToDecimalPlaces)(entry.contentRect.width, 1),
        height: (0, _roundToDecimalPlaces.roundToDecimalPlaces)(entry.contentRect.height, 1)
      };
      if (newSize.width === lastSize.width && newSize.height === lastSize.height) {
        return;
      }
      apiRef.current.publishEvent('resize', newSize);
      lastSize = newSize;
    });
    observer.observe(node);
    if (_reactMajor.default >= 19) {
      return () => {
        mainRef.current = null;
        observer.disconnect();
      };
    }
    return undefined;
  }, [apiRef, mainRef]);

  /*
   * Scroll context logic
   * ====================
   * We only render the cells contained in the `renderContext`. However, when the user starts scrolling the grid
   * in a direction, we want to render as many cells as possible in that direction, as to avoid presenting white
   * areas if the user scrolls too fast/far and the viewport ends up in a region we haven't rendered yet. To render
   * more cells, we store some offsets to add to the viewport in `scrollCache.buffer`. Those offsets make the render
   * context wider in the direction the user is going, but also makes the buffer around the viewport `0` for the
   * dimension (horizontal or vertical) in which the user is not scrolling. So if the normal viewport is 8 columns
   * wide, with a 1 column buffer (10 columns total), then we want it to be exactly 8 columns wide during vertical
   * scroll.
   * However, we don't want the rows in the old context to re-render from e.g. 10 columns to 8 columns, because that's
   * work that's not necessary. Thus we store the context at the start of the scroll in `frozenContext`, and the rows
   * that are part of this old context will keep their same render context as to avoid re-rendering.
   */
  const scrollPosition = React.useRef(rootProps.initialState?.scroll ?? EMPTY_SCROLL_POSITION);
  const ignoreNextScrollEvent = React.useRef(false);
  const previousContextScrollPosition = React.useRef(EMPTY_SCROLL_POSITION);
  const previousRowContext = React.useRef(_useGridVirtualization.EMPTY_RENDER_CONTEXT);
  const renderContext = (0, _useGridSelector.useGridSelector)(apiRef, _gridVirtualizationSelectors.gridRenderContextSelector);
  const focusedVirtualCell = (0, _useGridSelector.useGridSelector)(apiRef, _gridFocusedVirtualCellSelector.gridFocusedVirtualCellSelector);
  const scrollTimeout = (0, _useTimeout.default)();
  const frozenContext = React.useRef(undefined);
  const scrollCache = (0, _useLazyRef.default)(() => createScrollCache(isRtl, rootProps.rowBufferPx, rootProps.columnBufferPx, rowHeight * 15, MINIMUM_COLUMN_WIDTH * 6)).current;
  const updateRenderContext = React.useCallback(nextRenderContext => {
    if (areRenderContextsEqual(nextRenderContext, apiRef.current.state.virtualization.renderContext)) {
      return;
    }
    const didRowsIntervalChange = nextRenderContext.firstRowIndex !== previousRowContext.current.firstRowIndex || nextRenderContext.lastRowIndex !== previousRowContext.current.lastRowIndex;
    apiRef.current.setState(state => {
      return (0, _extends2.default)({}, state, {
        virtualization: (0, _extends2.default)({}, state.virtualization, {
          renderContext: nextRenderContext
        })
      });
    });

    // The lazy-loading hook is listening to `renderedRowsIntervalChange`,
    // but only does something if we already have a render context, because
    // otherwise we would call an update directly on mount
    const isReady = (0, _gridDimensionsSelectors.gridDimensionsSelector)(apiRef).isReady;
    if (isReady && didRowsIntervalChange) {
      previousRowContext.current = nextRenderContext;
      apiRef.current.publishEvent('renderedRowsIntervalChange', nextRenderContext);
    }
    previousContextScrollPosition.current = scrollPosition.current;
  }, [apiRef]);
  const triggerUpdateRenderContext = (0, _useEventCallback.default)(() => {
    const scroller = scrollerRef.current;
    if (!scroller) {
      return undefined;
    }
    const dimensions = (0, _gridDimensionsSelectors.gridDimensionsSelector)(apiRef);
    const maxScrollTop = Math.ceil(dimensions.minimumSize.height - dimensions.viewportOuterSize.height);
    const maxScrollLeft = Math.ceil(dimensions.minimumSize.width - dimensions.viewportInnerSize.width);

    // Clamp the scroll position to the viewport to avoid re-calculating the render context for scroll bounce
    const newScroll = {
      top: (0, _utils2.clamp)(scroller.scrollTop, 0, maxScrollTop),
      left: isRtl ? (0, _utils2.clamp)(scroller.scrollLeft, -maxScrollLeft, 0) : (0, _utils2.clamp)(scroller.scrollLeft, 0, maxScrollLeft)
    };
    const dx = newScroll.left - scrollPosition.current.left;
    const dy = newScroll.top - scrollPosition.current.top;
    const isScrolling = dx !== 0 || dy !== 0;
    scrollPosition.current = newScroll;
    const direction = isScrolling ? directionForDelta(dx, dy) : ScrollDirection.NONE;

    // Since previous render, we have scrolled...
    const rowScroll = Math.abs(scrollPosition.current.top - previousContextScrollPosition.current.top);
    const columnScroll = Math.abs(scrollPosition.current.left - previousContextScrollPosition.current.left);

    // PERF: use the computed minimum column width instead of a static one
    const didCrossThreshold = rowScroll >= rowHeight || columnScroll >= MINIMUM_COLUMN_WIDTH;
    const didChangeDirection = scrollCache.direction !== direction;
    const shouldUpdate = didCrossThreshold || didChangeDirection;
    if (!shouldUpdate) {
      return renderContext;
    }

    // Render a new context

    if (didChangeDirection) {
      switch (direction) {
        case ScrollDirection.NONE:
        case ScrollDirection.LEFT:
        case ScrollDirection.RIGHT:
          frozenContext.current = undefined;
          break;
        default:
          frozenContext.current = renderContext;
          break;
      }
    }
    scrollCache.direction = direction;
    scrollCache.buffer = bufferForDirection(isRtl, direction, rootProps.rowBufferPx, rootProps.columnBufferPx, rowHeight * 15, MINIMUM_COLUMN_WIDTH * 6);
    const inputs = inputsSelector(apiRef, rootProps, enabledForRows, enabledForColumns);
    const nextRenderContext = computeRenderContext(inputs, scrollPosition.current, scrollCache);
    if (!areRenderContextsEqual(nextRenderContext, renderContext)) {
      // Prevents batching render context changes
      ReactDOM.flushSync(() => {
        updateRenderContext(nextRenderContext);
      });
      scrollTimeout.start(1000, triggerUpdateRenderContext);
    }
    return nextRenderContext;
  });
  const forceUpdateRenderContext = () => {
    // skip update if dimensions are not ready and virtualization is enabled
    if (!(0, _gridDimensionsSelectors.gridDimensionsSelector)(apiRef).isReady && (enabledForRows || enabledForColumns)) {
      return;
    }
    const inputs = inputsSelector(apiRef, rootProps, enabledForRows, enabledForColumns);
    const nextRenderContext = computeRenderContext(inputs, scrollPosition.current, scrollCache);
    // Reset the frozen context when the render context changes, see the illustration in https://github.com/mui/mui-x/pull/12353
    frozenContext.current = undefined;
    updateRenderContext(nextRenderContext);
  };
  const handleScroll = (0, _useEventCallback.default)(() => {
    if (ignoreNextScrollEvent.current) {
      ignoreNextScrollEvent.current = false;
      return;
    }
    const nextRenderContext = triggerUpdateRenderContext();
    apiRef.current.publishEvent('scrollPositionChange', {
      top: scrollPosition.current.top,
      left: scrollPosition.current.left,
      renderContext: nextRenderContext
    });
  });
  const handleWheel = (0, _useEventCallback.default)(event => {
    apiRef.current.publishEvent('virtualScrollerWheel', {}, event);
  });
  const handleTouchMove = (0, _useEventCallback.default)(event => {
    apiRef.current.publishEvent('virtualScrollerTouchMove', {}, event);
  });
  const getRows = (params = {}) => {
    if (!params.rows && !currentPage.range) {
      return [];
    }
    const rowTree = (0, _gridRowsSelector.gridRowTreeSelector)(apiRef);
    let baseRenderContext = renderContext;
    if (params.renderContext) {
      baseRenderContext = params.renderContext;
      baseRenderContext.firstColumnIndex = renderContext.firstColumnIndex;
      baseRenderContext.lastColumnIndex = renderContext.lastColumnIndex;
    }
    const isLastSection = !hasBottomPinnedRows && params.position === undefined || hasBottomPinnedRows && params.position === 'bottom';
    const isPinnedSection = params.position !== undefined;
    let rowIndexOffset;
    // FIXME: Why is the switch check exhaustiveness not validated with typescript-eslint?
    // eslint-disable-next-line default-case
    switch (params.position) {
      case 'top':
        rowIndexOffset = 0;
        break;
      case 'bottom':
        rowIndexOffset = pinnedRows.top.length + currentPage.rows.length;
        break;
      case undefined:
        rowIndexOffset = pinnedRows.top.length;
        break;
    }
    const rowModels = params.rows ?? currentPage.rows;
    const firstRowToRender = baseRenderContext.firstRowIndex;
    const lastRowToRender = Math.min(baseRenderContext.lastRowIndex, rowModels.length);
    const rowIndexes = params.rows ? (0, _utils2.range)(0, params.rows.length) : (0, _utils2.range)(firstRowToRender, lastRowToRender);
    let virtualRowIndex = -1;
    if (!isPinnedSection && focusedVirtualCell) {
      if (focusedVirtualCell.rowIndex < firstRowToRender) {
        rowIndexes.unshift(focusedVirtualCell.rowIndex);
        virtualRowIndex = focusedVirtualCell.rowIndex;
      }
      if (focusedVirtualCell.rowIndex > lastRowToRender) {
        rowIndexes.push(focusedVirtualCell.rowIndex);
        virtualRowIndex = focusedVirtualCell.rowIndex;
      }
    }
    const rows = [];
    const rowProps = rootProps.slotProps?.row;
    const columnPositions = (0, _gridColumnsSelector.gridColumnPositionsSelector)(apiRef);
    rowIndexes.forEach(rowIndexInPage => {
      const {
        id,
        model
      } = rowModels[rowIndexInPage];

      // In certain cases, the state might already be updated and `currentPage.rows` (which sets `rowModels`)
      // contains stale data.
      // In that case, skip any further row processing.
      // See:
      // - https://github.com/mui/mui-x/issues/16638
      // - https://github.com/mui/mui-x/issues/17022
      if (!rowTree[id]) {
        return;
      }
      const rowIndex = (currentPage?.range?.firstRowIndex || 0) + rowIndexOffset + rowIndexInPage;

      // NOTE: This is an expensive feature, the colSpan code could be optimized.
      if (hasColSpan) {
        const minFirstColumn = pinnedColumns.left.length;
        const maxLastColumn = visibleColumns.length - pinnedColumns.right.length;
        apiRef.current.calculateColSpan({
          rowId: id,
          minFirstColumn,
          maxLastColumn,
          columns: visibleColumns
        });
        if (pinnedColumns.left.length > 0) {
          apiRef.current.calculateColSpan({
            rowId: id,
            minFirstColumn: 0,
            maxLastColumn: pinnedColumns.left.length,
            columns: visibleColumns
          });
        }
        if (pinnedColumns.right.length > 0) {
          apiRef.current.calculateColSpan({
            rowId: id,
            minFirstColumn: visibleColumns.length - pinnedColumns.right.length,
            maxLastColumn: visibleColumns.length,
            columns: visibleColumns
          });
        }
      }
      const baseRowHeight = !apiRef.current.rowHasAutoHeight(id) ? apiRef.current.unstable_getRowHeight(id) : 'auto';
      const isSelected = rowSelectionManager.has(id) && apiRef.current.isRowSelectable(id);
      let isFirstVisible = false;
      if (params.position === undefined) {
        isFirstVisible = rowIndexInPage === 0;
      }
      let isLastVisible = false;
      const isLastVisibleInSection = rowIndexInPage === rowModels.length - 1;
      if (isLastSection) {
        if (!isPinnedSection) {
          const lastIndex = currentPage.rows.length - 1;
          const isLastVisibleRowIndex = rowIndexInPage === lastIndex;
          if (isLastVisibleRowIndex) {
            isLastVisible = true;
          }
        } else {
          isLastVisible = isLastVisibleInSection;
        }
      }
      let currentRenderContext = baseRenderContext;
      if (frozenContext.current && rowIndexInPage >= frozenContext.current.firstRowIndex && rowIndexInPage < frozenContext.current.lastRowIndex) {
        currentRenderContext = frozenContext.current;
      }
      const isVirtualFocusRow = rowIndexInPage === virtualRowIndex;
      const isVirtualFocusColumn = focusedVirtualCell?.rowIndex === rowIndex;
      const offsetLeft = computeOffsetLeft(columnPositions, currentRenderContext, pinnedColumns.left.length);
      const showBottomBorder = isLastVisibleInSection && params.position === 'top';
      const firstColumnIndex = currentRenderContext.firstColumnIndex;
      const lastColumnIndex = currentRenderContext.lastColumnIndex;
      rows.push(/*#__PURE__*/(0, _jsxRuntime.jsx)(rootProps.slots.row, (0, _extends2.default)({
        row: model,
        rowId: id,
        index: rowIndex,
        selected: isSelected,
        offsetLeft: offsetLeft,
        columnsTotalWidth: columnsTotalWidth,
        rowHeight: baseRowHeight,
        pinnedColumns: pinnedColumns,
        visibleColumns: visibleColumns,
        firstColumnIndex: firstColumnIndex,
        lastColumnIndex: lastColumnIndex,
        focusedColumnIndex: isVirtualFocusColumn ? focusedVirtualCell.columnIndex : undefined,
        isFirstVisible: isFirstVisible,
        isLastVisible: isLastVisible,
        isNotVisible: isVirtualFocusRow,
        showBottomBorder: showBottomBorder,
        scrollbarWidth: verticalScrollbarWidth,
        gridHasFiller: gridHasFiller
      }, rowProps), id));
      if (isVirtualFocusRow) {
        return;
      }
      const panel = panels.get(id);
      if (panel) {
        rows.push(panel);
      }
      if (params.position === undefined && isLastVisibleInSection) {
        rows.push(apiRef.current.getInfiniteLoadingTriggerElement?.({
          lastRowId: id
        }));
      }
    });
    return rows;
  };
  const scrollerStyle = React.useMemo(() => ({
    overflowX: !needsHorizontalScrollbar || listView ? 'hidden' : undefined,
    overflowY: rootProps.autoHeight ? 'hidden' : undefined
  }), [needsHorizontalScrollbar, rootProps.autoHeight, listView]);
  const contentSize = React.useMemo(() => {
    const size = {
      width: needsHorizontalScrollbar ? columnsTotalWidth : 'auto',
      flexBasis: contentHeight,
      flexShrink: 0
    };
    if (size.flexBasis === 0) {
      size.flexBasis = _gridRowsUtils.minimalContentHeight; // Give room to show the overlay when there no rows.
    }
    return size;
  }, [columnsTotalWidth, contentHeight, needsHorizontalScrollbar]);
  const onContentSizeApplied = React.useCallback(node => {
    if (!node) {
      return;
    }
    apiRef.current.publishEvent('virtualScrollerContentSizeChange', {
      columnsTotalWidth,
      contentHeight
    });
  }, [apiRef, columnsTotalWidth, contentHeight]);
  (0, _useEnhancedEffect.default)(() => {
    if (!isRenderContextReady.current) {
      return;
    }
    apiRef.current.updateRenderContext?.();
  }, [apiRef, enabledForColumns, enabledForRows]);
  (0, _useEnhancedEffect.default)(() => {
    if (listView) {
      scrollerRef.current.scrollLeft = 0;
    }
  }, [listView, scrollerRef]);
  (0, _useRunOnce.useRunOnce)(renderContext !== _useGridVirtualization.EMPTY_RENDER_CONTEXT, () => {
    apiRef.current.publishEvent('scrollPositionChange', {
      top: scrollPosition.current.top,
      left: scrollPosition.current.left,
      renderContext
    });
    isRenderContextReady.current = true;
    if (rootProps.initialState?.scroll && scrollerRef.current) {
      const scroller = scrollerRef.current;
      const {
        top,
        left
      } = rootProps.initialState.scroll;

      // On initial mount, if we have columns available, we can restore the horizontal scroll immediately, but we need to skip the resulting scroll event, otherwise we would recalculate the render context at position top=0, left=restoredValue, but the initial render context is already calculated based on the initial value of scrollPosition ref.
      const isScrollRestored = {
        top: !(top > 0),
        left: !(left > 0)
      };
      if (!isScrollRestored.left && columnsTotalWidth) {
        scroller.scrollLeft = left;
        ignoreNextScrollEvent.current = true;
        isScrollRestored.left = true;
      }

      // For the sake of completeness, but I'm not sure if contentHeight is ever available at this point. Maybe when virtualisation is disabled?
      if (!isScrollRestored.top && contentHeight) {
        scroller.scrollTop = top;
        ignoreNextScrollEvent.current = true;
        isScrollRestored.top = true;
      }

      // To restore the vertical scroll, we need to wait until the rows are available in the DOM (otherwise there's nowhere to scroll), but before paint to avoid reflows
      if (!isScrollRestored.top || !isScrollRestored.left) {
        const unsubscribeContentSizeChange = apiRef.current.subscribeEvent('virtualScrollerContentSizeChange', params => {
          if (!isScrollRestored.left && params.columnsTotalWidth) {
            scroller.scrollLeft = left;
            ignoreNextScrollEvent.current = true;
            isScrollRestored.left = true;
          }
          if (!isScrollRestored.top && params.contentHeight) {
            scroller.scrollTop = top;
            ignoreNextScrollEvent.current = true;
            isScrollRestored.top = true;
          }
          if (isScrollRestored.left && isScrollRestored.top) {
            unsubscribeContentSizeChange();
          }
        });
        return unsubscribeContentSizeChange;
      }
    }
    return undefined;
  });
  apiRef.current.register('private', {
    updateRenderContext: forceUpdateRenderContext
  });
  (0, _utils.useGridEventPriority)(apiRef, 'sortedRowsSet', forceUpdateRenderContext);
  (0, _utils.useGridEventPriority)(apiRef, 'paginationModelChange', forceUpdateRenderContext);
  (0, _utils.useGridEventPriority)(apiRef, 'columnsChange', forceUpdateRenderContext);
  return {
    renderContext,
    setPanels,
    getRows,
    getContainerProps: () => ({
      ref: mainRefCallback
    }),
    getScrollerProps: () => ({
      ref: scrollerRef,
      onScroll: handleScroll,
      onWheel: handleWheel,
      onTouchMove: handleTouchMove,
      style: scrollerStyle,
      role: 'presentation',
      // `tabIndex` shouldn't be used along role=presentation, but it fixes a Firefox bug
      // https://github.com/mui/mui-x/pull/13891#discussion_r1683416024
      tabIndex: platform.isFirefox ? -1 : undefined
    }),
    getContentProps: () => ({
      style: contentSize,
      role: 'presentation',
      ref: onContentSizeApplied
    }),
    getRenderZoneProps: () => ({
      role: 'rowgroup'
    }),
    getScrollbarVerticalProps: () => ({
      ref: scrollbarVerticalRef,
      scrollPosition
    }),
    getScrollbarHorizontalProps: () => ({
      ref: scrollbarHorizontalRef,
      scrollPosition
    }),
    getScrollAreaProps: () => ({
      scrollPosition
    })
  };
};
exports.useGridVirtualScroller = useGridVirtualScroller;
// dimension selectors
function needsHorizontalScrollbarSelector(apiRef) {
  return apiRef.current.state.dimensions.viewportOuterSize.width > 0 && apiRef.current.state.dimensions.columnsTotalWidth > apiRef.current.state.dimensions.viewportOuterSize.width;
}
function inputsSelector(apiRef, rootProps, enabledForRows, enabledForColumns) {
  const dimensions = (0, _gridDimensionsSelectors.gridDimensionsSelector)(apiRef);
  const currentPage = (0, _useGridVisibleRows.getVisibleRows)(apiRef, rootProps);
  const visibleColumns = rootProps.listView ? [(0, _gridListViewSelectors.gridListColumnSelector)(apiRef)] : (0, _gridColumnsSelector.gridVisibleColumnDefinitionsSelector)(apiRef);
  const hiddenCellsOriginMap = (0, _gridRowSpanningSelectors.gridRowSpanningHiddenCellsOriginMapSelector)(apiRef);
  const lastRowId = apiRef.current.state.rows.dataRowIds.at(-1);
  const lastColumn = visibleColumns.at(-1);
  return {
    enabledForRows,
    enabledForColumns,
    apiRef,
    autoHeight: rootProps.autoHeight,
    rowBufferPx: rootProps.rowBufferPx,
    columnBufferPx: rootProps.columnBufferPx,
    leftPinnedWidth: dimensions.leftPinnedWidth,
    columnsTotalWidth: dimensions.columnsTotalWidth,
    viewportInnerWidth: dimensions.viewportInnerSize.width,
    viewportInnerHeight: dimensions.viewportInnerSize.height,
    lastRowHeight: lastRowId !== undefined ? apiRef.current.unstable_getRowHeight(lastRowId) : 0,
    lastColumnWidth: lastColumn?.computedWidth ?? 0,
    rowsMeta: (0, _gridRowsMetaSelector.gridRowsMetaSelector)(apiRef),
    columnPositions: (0, _gridColumnsSelector.gridColumnPositionsSelector)(apiRef),
    rows: currentPage.rows,
    range: currentPage.range,
    pinnedColumns: (0, _gridColumnsSelector.gridVisiblePinnedColumnDefinitionsSelector)(apiRef),
    visibleColumns,
    hiddenCellsOriginMap,
    listView: rootProps.listView ?? false,
    virtualizeColumnsWithAutoRowHeight: rootProps.virtualizeColumnsWithAutoRowHeight
  };
}
function computeRenderContext(inputs, scrollPosition, scrollCache) {
  const renderContext = {
    firstRowIndex: 0,
    lastRowIndex: inputs.rows.length,
    firstColumnIndex: 0,
    lastColumnIndex: inputs.visibleColumns.length
  };
  const {
    top,
    left
  } = scrollPosition;
  const realLeft = Math.abs(left) + inputs.leftPinnedWidth;
  if (inputs.enabledForRows) {
    // Clamp the value because the search may return an index out of bounds.
    // In the last index, this is not needed because Array.slice doesn't include it.
    let firstRowIndex = Math.min(getNearestIndexToRender(inputs, top, {
      atStart: true,
      lastPosition: inputs.rowsMeta.positions[inputs.rowsMeta.positions.length - 1] + inputs.lastRowHeight
    }), inputs.rowsMeta.positions.length - 1);

    // If any of the cells in the `firstRowIndex` is hidden due to an extended row span,
    // Make sure the row from where the rowSpan is originated is visible.
    const rowSpanHiddenCellOrigin = inputs.hiddenCellsOriginMap[firstRowIndex];
    if (rowSpanHiddenCellOrigin) {
      const minSpannedRowIndex = Math.min(...Object.values(rowSpanHiddenCellOrigin));
      firstRowIndex = Math.min(firstRowIndex, minSpannedRowIndex);
    }
    const lastRowIndex = inputs.autoHeight ? firstRowIndex + inputs.rows.length : getNearestIndexToRender(inputs, top + inputs.viewportInnerHeight);
    renderContext.firstRowIndex = firstRowIndex;
    renderContext.lastRowIndex = lastRowIndex;
  }
  if (inputs.listView) {
    return (0, _extends2.default)({}, renderContext, {
      lastColumnIndex: 1
    });
  }
  if (inputs.enabledForColumns) {
    let firstColumnIndex = 0;
    let lastColumnIndex = inputs.columnPositions.length;
    let hasRowWithAutoHeight = false;
    const [firstRowToRender, lastRowToRender] = getIndexesToRender({
      firstIndex: renderContext.firstRowIndex,
      lastIndex: renderContext.lastRowIndex,
      minFirstIndex: 0,
      maxLastIndex: inputs.rows.length,
      bufferBefore: scrollCache.buffer.rowBefore,
      bufferAfter: scrollCache.buffer.rowAfter,
      positions: inputs.rowsMeta.positions,
      lastSize: inputs.lastRowHeight
    });
    if (!inputs.virtualizeColumnsWithAutoRowHeight) {
      for (let i = firstRowToRender; i < lastRowToRender && !hasRowWithAutoHeight; i += 1) {
        const row = inputs.rows[i];
        hasRowWithAutoHeight = inputs.apiRef.current.rowHasAutoHeight(row.id);
      }
    }
    if (!hasRowWithAutoHeight || inputs.virtualizeColumnsWithAutoRowHeight) {
      firstColumnIndex = binarySearch(realLeft, inputs.columnPositions, {
        atStart: true,
        lastPosition: inputs.columnsTotalWidth
      });
      lastColumnIndex = binarySearch(realLeft + inputs.viewportInnerWidth, inputs.columnPositions);
    }
    renderContext.firstColumnIndex = firstColumnIndex;
    renderContext.lastColumnIndex = lastColumnIndex;
  }
  const actualRenderContext = deriveRenderContext(inputs, renderContext, scrollCache);
  return actualRenderContext;
}
function getNearestIndexToRender(inputs, offset, options) {
  const lastMeasuredIndexRelativeToAllRows = inputs.apiRef.current.getLastMeasuredRowIndex();
  let allRowsMeasured = lastMeasuredIndexRelativeToAllRows === Infinity;
  if (inputs.range?.lastRowIndex && !allRowsMeasured) {
    // Check if all rows in this page are already measured
    allRowsMeasured = lastMeasuredIndexRelativeToAllRows >= inputs.range.lastRowIndex;
  }
  const lastMeasuredIndexRelativeToCurrentPage = (0, _utils2.clamp)(lastMeasuredIndexRelativeToAllRows - (inputs.range?.firstRowIndex || 0), 0, inputs.rowsMeta.positions.length);
  if (allRowsMeasured || inputs.rowsMeta.positions[lastMeasuredIndexRelativeToCurrentPage] >= offset) {
    // If all rows were measured (when no row has "auto" as height) or all rows before the offset
    // were measured, then use a binary search because it's faster.
    return binarySearch(offset, inputs.rowsMeta.positions, options);
  }

  // Otherwise, use an exponential search.
  // If rows have "auto" as height, their positions will be based on estimated heights.
  // In this case, we can skip several steps until we find a position higher than the offset.
  // Inspired by https://github.com/bvaughn/react-virtualized/blob/master/source/Grid/utils/CellSizeAndPositionManager.js
  return exponentialSearch(offset, inputs.rowsMeta.positions, lastMeasuredIndexRelativeToCurrentPage, options);
}

/**
 * Accepts as input a raw render context (the area visible in the viewport) and adds
 * computes the actual render context based on pinned elements, buffer dimensions and
 * spanning.
 */
function deriveRenderContext(inputs, nextRenderContext, scrollCache) {
  const [firstRowToRender, lastRowToRender] = getIndexesToRender({
    firstIndex: nextRenderContext.firstRowIndex,
    lastIndex: nextRenderContext.lastRowIndex,
    minFirstIndex: 0,
    maxLastIndex: inputs.rows.length,
    bufferBefore: scrollCache.buffer.rowBefore,
    bufferAfter: scrollCache.buffer.rowAfter,
    positions: inputs.rowsMeta.positions,
    lastSize: inputs.lastRowHeight
  });
  const [initialFirstColumnToRender, lastColumnToRender] = getIndexesToRender({
    firstIndex: nextRenderContext.firstColumnIndex,
    lastIndex: nextRenderContext.lastColumnIndex,
    minFirstIndex: inputs.pinnedColumns.left.length,
    maxLastIndex: inputs.visibleColumns.length - inputs.pinnedColumns.right.length,
    bufferBefore: scrollCache.buffer.columnBefore,
    bufferAfter: scrollCache.buffer.columnAfter,
    positions: inputs.columnPositions,
    lastSize: inputs.lastColumnWidth
  });
  const firstColumnToRender = (0, _gridColumnsUtils.getFirstNonSpannedColumnToRender)({
    firstColumnToRender: initialFirstColumnToRender,
    apiRef: inputs.apiRef,
    firstRowToRender,
    lastRowToRender,
    visibleRows: inputs.rows
  });
  return {
    firstRowIndex: firstRowToRender,
    lastRowIndex: lastRowToRender,
    firstColumnIndex: firstColumnToRender,
    lastColumnIndex: lastColumnToRender
  };
}
/**
 * Use binary search to avoid looping through all possible positions.
 * The `options.atStart` provides the possibility to match for the first element that
 * intersects the screen, even if said element's start position is before `offset`. In
 * other words, we search for `offset + width`.
 */
function binarySearch(offset, positions, options = undefined, sliceStart = 0, sliceEnd = positions.length) {
  if (positions.length <= 0) {
    return -1;
  }
  if (sliceStart >= sliceEnd) {
    return sliceStart;
  }
  const pivot = sliceStart + Math.floor((sliceEnd - sliceStart) / 2);
  const position = positions[pivot];
  let isBefore;
  if (options?.atStart) {
    const width = (pivot === positions.length - 1 ? options.lastPosition : positions[pivot + 1]) - position;
    isBefore = offset - width < position;
  } else {
    isBefore = offset <= position;
  }
  return isBefore ? binarySearch(offset, positions, options, sliceStart, pivot) : binarySearch(offset, positions, options, pivot + 1, sliceEnd);
}
function exponentialSearch(offset, positions, index, options = undefined) {
  let interval = 1;
  while (index < positions.length && Math.abs(positions[index]) < offset) {
    index += interval;
    interval *= 2;
  }
  return binarySearch(offset, positions, options, Math.floor(index / 2), Math.min(index, positions.length));
}
function getIndexesToRender({
  firstIndex,
  lastIndex,
  bufferBefore,
  bufferAfter,
  minFirstIndex,
  maxLastIndex,
  positions,
  lastSize
}) {
  const firstPosition = positions[firstIndex] - bufferBefore;
  const lastPosition = positions[lastIndex] + bufferAfter;
  const firstIndexPadded = binarySearch(firstPosition, positions, {
    atStart: true,
    lastPosition: positions[positions.length - 1] + lastSize
  });
  const lastIndexPadded = binarySearch(lastPosition, positions);
  return [(0, _utils2.clamp)(firstIndexPadded, minFirstIndex, maxLastIndex), (0, _utils2.clamp)(lastIndexPadded, minFirstIndex, maxLastIndex)];
}
function areRenderContextsEqual(context1, context2) {
  if (context1 === context2) {
    return true;
  }
  return context1.firstRowIndex === context2.firstRowIndex && context1.lastRowIndex === context2.lastRowIndex && context1.firstColumnIndex === context2.firstColumnIndex && context1.lastColumnIndex === context2.lastColumnIndex;
}
function computeOffsetLeft(columnPositions, renderContext, pinnedLeftLength) {
  const left = (columnPositions[renderContext.firstColumnIndex] ?? 0) - (columnPositions[pinnedLeftLength] ?? 0);
  return Math.abs(left);
}
function directionForDelta(dx, dy) {
  if (dx === 0 && dy === 0) {
    return ScrollDirection.NONE;
  }
  /* eslint-disable */
  if (Math.abs(dy) >= Math.abs(dx)) {
    if (dy > 0) {
      return ScrollDirection.DOWN;
    } else {
      return ScrollDirection.UP;
    }
  } else {
    if (dx > 0) {
      return ScrollDirection.RIGHT;
    } else {
      return ScrollDirection.LEFT;
    }
  }
  /* eslint-enable */
}
function bufferForDirection(isRtl, direction, rowBufferPx, columnBufferPx, verticalBuffer, horizontalBuffer) {
  if (isRtl) {
    switch (direction) {
      case ScrollDirection.LEFT:
        direction = ScrollDirection.RIGHT;
        break;
      case ScrollDirection.RIGHT:
        direction = ScrollDirection.LEFT;
        break;
      default:
    }
  }
  switch (direction) {
    case ScrollDirection.NONE:
      return {
        rowAfter: rowBufferPx,
        rowBefore: rowBufferPx,
        columnAfter: columnBufferPx,
        columnBefore: columnBufferPx
      };
    case ScrollDirection.LEFT:
      return {
        rowAfter: 0,
        rowBefore: 0,
        columnAfter: 0,
        columnBefore: horizontalBuffer
      };
    case ScrollDirection.RIGHT:
      return {
        rowAfter: 0,
        rowBefore: 0,
        columnAfter: horizontalBuffer,
        columnBefore: 0
      };
    case ScrollDirection.UP:
      return {
        rowAfter: 0,
        rowBefore: verticalBuffer,
        columnAfter: 0,
        columnBefore: 0
      };
    case ScrollDirection.DOWN:
      return {
        rowAfter: verticalBuffer,
        rowBefore: 0,
        columnAfter: 0,
        columnBefore: 0
      };
    default:
      // eslint unable to figure out enum exhaustiveness
      throw new Error('unreachable');
  }
}